/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.AccelerationComponent;
import com.adsittech.dinotamer.AttackEntityComponent;
import com.adsittech.dinotamer.CurrentlyAttackingComponent;
import com.adsittech.dinotamer.Entity;
import com.adsittech.dinotamer.EntityController;
import com.adsittech.dinotamer.EntityFactory;
import com.adsittech.dinotamer.MaxVelocityComponent;
import com.adsittech.dinotamer.MoveToLocationComponent;
import com.adsittech.dinotamer.TeamComponent;
import com.adsittech.dinotamer.VelocityComponent;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import java.util.ArrayList;

public class Game {
    private EntityController entityController;
    private Entity player;
    private EntityFactory entityFactory;
    public static final int STATUS_GAME_RUNNING = 0;
    public static final int STATUS_GAME_OVER = 1;
    public static final int STATUS_GAME_PAUSED = 2;
    public static final int STATUS_GAME_NOT_STARTED = 3;
    public static final int STATUS_GAME_OVER_PROCESSED = 4;
    public static final int STATUS_GAME_OVER_PROCESSING = 5;
    private int status;
    public static final int DIFFICULTY_EASY = 0;
    public static final int DIFFICULTY_NORMAL = 1;
    public static final int DIFFICULTY_HARD = 2;
    private float timeSoFar;
    private float timeSinceLastEnemyCreated;
    private float enemyGenerationTime;
    private int score;
    private ArrayList<Integer> keysDown;

    public Game(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
        this.keysDown = new ArrayList();
        this.initialize();
    }

    public void initialize() {
        this.entityController = new EntityController();
        this.player = this.entityFactory.PlayerEntity();
        this.entityController.addEntity(this.player);
        this.timeSoFar = 0.0f;
        this.timeSinceLastEnemyCreated = 0.0f;
        this.entityController.addEntity(this.entityFactory.LongNeckEntity());
        this.entityController.addEntity(this.entityFactory.SalamanderEntity());
        this.entityController.addEntity(this.entityFactory.TriceritopsEntity());
        this.enemyGenerationTime = 12.0f;
        this.score = 0;
        this.setStatus(3);
    }

    public void handleKeyDownEvent(int keyCode) {
        this.keysDown.add(keyCode);
    }

    public void handleKeyUpEvent(Integer keyCode) {
        this.keysDown.remove(keyCode);
    }

    public void newGame() {
        this.initialize();
        this.setStatus(0);
    }

    public void moveToLocation(float x, float y) {
        for (Entity entity : (ArrayList)this.entityController.getTeamEntities().get((Object)1)) {
            if (entity == this.player) continue;
            entity.removeComponent("AttackEntityComponent");
            entity.addComponent(new MoveToLocationComponent(x, y));
        }
    }

    public void attackEntityAt(float x, float y) {
        TeamComponent playerTeam = (TeamComponent)this.player.getComponent("TeamComponent");
        int entityToAttack = -1;
        for (Entity entity : this.entityController.getEntities()) {
            Rectangle defenseArea;
            TeamComponent team = (TeamComponent)entity.getComponent("TeamComponent");
            if (team != null && (team == null || playerTeam == null || team.getTeam() == playerTeam.getTeam()) || (defenseArea = EntityController.getActualDefenseAreaRectangle(entity)) == null || !defenseArea.contains(x, y)) continue;
            entityToAttack = entity.getId();
        }
        for (Entity entity : (ArrayList)this.entityController.getTeamEntities().get((Object)1)) {
            if (entity == this.player) continue;
            entity.addComponent(new AttackEntityComponent(entityToAttack));
        }
    }

    public void advance(float delta) {
        if (this.getStatus() == 0) {
            this.timeSoFar += delta;
            this.timeSinceLastEnemyCreated += delta;
            if (this.timeSinceLastEnemyCreated > this.enemyGenerationTime && MathUtils.random((int)10) > ((ArrayList)this.entityController.getTeamEntities().get((Object)2)).size()) {
                this.spawnEnemy();
            }
            this.score += this.entityController.updateEntities(delta);
            if (!this.entityController.getEntities().contains(this.player)) {
                this.setStatus(1);
            }
            this.handleKeysDown(delta);
        }
    }

    public void handleKeysDown(float delta) {
        VelocityComponent playerVelocity = (VelocityComponent)this.player.getComponent("VelocityComponent");
        MaxVelocityComponent maxVelocity = (MaxVelocityComponent)this.player.getComponent("MaxVelocityComponent");
        AccelerationComponent acceleration = (AccelerationComponent)this.player.getComponent("AccelerationComponent");
        VelocityComponent newVelocity = new VelocityComponent(0.0f, 0.0f);
        for (Integer keyCode : this.keysDown) {
            CurrentlyAttackingComponent currentlyAttacking;
            if (acceleration != null) {
                if (keyCode == 29) {
                    if (playerVelocity != null && playerVelocity.getVelocity().x > 0.0f) {
                        playerVelocity.getVelocity().x = 0.0f;
                    }
                    newVelocity.getVelocity().x = -acceleration.getAcceleration() * delta;
                } else if (keyCode == 47) {
                    if (playerVelocity != null && playerVelocity.getVelocity().y > 0.0f) {
                        playerVelocity.getVelocity().y = 0.0f;
                    }
                    newVelocity.getVelocity().y = -acceleration.getAcceleration() * delta;
                } else if (keyCode == 32) {
                    if (playerVelocity != null && playerVelocity.getVelocity().x < 0.0f) {
                        playerVelocity.getVelocity().x = 0.0f;
                    }
                    newVelocity.getVelocity().x = acceleration.getAcceleration() * delta;
                } else if (keyCode == 51) {
                    if (playerVelocity != null && playerVelocity.getVelocity().y < 0.0f) {
                        playerVelocity.getVelocity().y = 0.0f;
                    }
                    newVelocity.getVelocity().y = acceleration.getAcceleration() * delta;
                }
            }
            if (keyCode != 62 || (currentlyAttacking = (CurrentlyAttackingComponent)this.player.getComponent("CurrentlyAttackingComponent")).checkAttacking()) continue;
            currentlyAttacking.startAttack();
        }
        if (playerVelocity == null) {
            playerVelocity = new VelocityComponent(0.0f, 0.0f);
            this.player.addComponent(playerVelocity);
        }
        if (acceleration != null) {
            if (newVelocity.getVelocity().x == 0.0f) {
                if (playerVelocity.getVelocity().x > 0.0f) {
                    playerVelocity.getVelocity().x = playerVelocity.getVelocity().x > acceleration.getAcceleration() * delta ? (playerVelocity.getVelocity().x -= acceleration.getAcceleration() * delta) : 0.0f;
                } else if (playerVelocity.getVelocity().x < 0.0f) {
                    playerVelocity.getVelocity().x = playerVelocity.getVelocity().x < -acceleration.getAcceleration() * delta ? (playerVelocity.getVelocity().x += acceleration.getAcceleration() * delta) : 0.0f;
                }
            }
            if (newVelocity.getVelocity().y == 0.0f) {
                if (playerVelocity.getVelocity().y > 0.0f) {
                    playerVelocity.getVelocity().y = playerVelocity.getVelocity().y > acceleration.getAcceleration() * delta ? (playerVelocity.getVelocity().y -= acceleration.getAcceleration() * delta) : 0.0f;
                } else if (playerVelocity.getVelocity().y < 0.0f) {
                    playerVelocity.getVelocity().y = playerVelocity.getVelocity().y < -acceleration.getAcceleration() * delta ? (playerVelocity.getVelocity().y += acceleration.getAcceleration() * delta) : 0.0f;
                }
            }
        }
        if (newVelocity.getVelocity().x == 0.0f && newVelocity.getVelocity().y == 0.0f) {
            playerVelocity.getVelocity().x = 0.0f;
            playerVelocity.getVelocity().y = 0.0f;
        } else {
            playerVelocity.getVelocity().x += newVelocity.getVelocity().x;
            playerVelocity.getVelocity().y += newVelocity.getVelocity().y;
            if (maxVelocity != null) {
                if (playerVelocity.getVelocity().x > maxVelocity.getMaxVelocity()) {
                    playerVelocity.getVelocity().x = maxVelocity.getMaxVelocity();
                } else if (playerVelocity.getVelocity().x < -maxVelocity.getMaxVelocity()) {
                    playerVelocity.getVelocity().x = -maxVelocity.getMaxVelocity();
                }
                if (playerVelocity.getVelocity().y > maxVelocity.getMaxVelocity()) {
                    playerVelocity.getVelocity().y = maxVelocity.getMaxVelocity();
                } else if (playerVelocity.getVelocity().y < -maxVelocity.getMaxVelocity()) {
                    playerVelocity.getVelocity().y = -maxVelocity.getMaxVelocity();
                }
            }
        }
        this.keysDown.remove(new Integer(62));
    }

    public void spawnEnemy() {
        int chance = MathUtils.random((int)100);
        this.timeSinceLastEnemyCreated = 0.0f;
        if (chance <= 50) {
            this.entityController.addEntity(this.entityFactory.SalamanderEntity());
        } else if (chance <= 80) {
            this.entityController.addEntity(this.entityFactory.TriceritopsEntity());
        } else {
            this.entityController.addEntity(this.entityFactory.LongNeckEntity());
        }
    }

    public EntityController getEntityController() {
        return this.entityController;
    }

    public void setEntityController(EntityController entityController) {
        this.entityController = entityController;
    }

    public Entity getPlayer() {
        return this.player;
    }

    public void setPlayer(Entity player) {
        this.player = player;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public float getTimeSoFar() {
        return this.timeSoFar;
    }

    public void setTimeSoFar(float timeSoFar) {
        this.timeSoFar = timeSoFar;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }
}

