/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.AIComponent;
import com.adsittech.dinotamer.AccelerationComponent;
import com.adsittech.dinotamer.AttackAreaComponent;
import com.adsittech.dinotamer.CurrentlyAttackingComponent;
import com.adsittech.dinotamer.DefenseAreaComponent;
import com.adsittech.dinotamer.DefenseComponent;
import com.adsittech.dinotamer.DirectionComponent;
import com.adsittech.dinotamer.Entity;
import com.adsittech.dinotamer.HealthComponent;
import com.adsittech.dinotamer.HealthRegenComponent;
import com.adsittech.dinotamer.MaxVelocityComponent;
import com.adsittech.dinotamer.PositionComponent;
import com.adsittech.dinotamer.SoundEffectComponent;
import com.adsittech.dinotamer.SpriteComponent;
import com.adsittech.dinotamer.StrengthComponent;
import com.adsittech.dinotamer.TamedComponent;
import com.adsittech.dinotamer.TeamComponent;
import com.badlogic.gdx.math.MathUtils;

public class EntityFactory {
    private SpriteComponent playerSprite;
    private SpriteComponent longNeckSprite;
    private SpriteComponent salamanderSprite;
    private SpriteComponent triceritopsSprite;

    public EntityFactory(SpriteComponent playerSprite, SpriteComponent longNeckSprite, SpriteComponent salamanderSprite, SpriteComponent triceritopsSprite) {
        this.setPlayerSprite(playerSprite);
        this.setLongNeckSprite(longNeckSprite);
        this.setSalamanderSprite(salamanderSprite);
        this.setTriceritopsSprite(triceritopsSprite);
    }

    public Entity PlayerEntity() {
        Entity player = new Entity();
        player.addComponent(new DefenseAreaComponent(0.0f, 0.0f, 37.0f, 45.0f));
        player.addComponent(new AttackAreaComponent(37.0f, 45.0f, 10.0f, 10.0f));
        player.addComponent(new HealthComponent(50));
        player.addComponent(new StrengthComponent(3));
        player.addComponent(new DefenseComponent(1));
        player.addComponent(new PositionComponent(MathUtils.random((float)800.0f), MathUtils.random((float)800.0f)));
        player.addComponent(new DirectionComponent(4));
        player.addComponent(new HealthRegenComponent(1, 3.0f));
        player.addComponent(new AccelerationComponent(100.0f));
        player.addComponent(new MaxVelocityComponent(200.0f));
        player.addComponent(new TeamComponent(1));
        player.addComponent(new CurrentlyAttackingComponent(0.5f, false));
        player.addComponent(this.playerSprite.copy());
        player.addComponent(new SoundEffectComponent(1));
        return player;
    }

    public Entity LongNeckEntity() {
        Entity enemy = new Entity();
        enemy.addComponent(new DefenseAreaComponent(-50.0f, -50.0f, 50.0f, 50.0f));
        enemy.addComponent(new AttackAreaComponent(0.0f, 0.0f, 0.0f, 0.0f));
        enemy.addComponent(new CurrentlyAttackingComponent(0.75f, false));
        enemy.addComponent(new HealthComponent(70));
        enemy.addComponent(new StrengthComponent(5));
        enemy.addComponent(new DefenseComponent(2));
        enemy.addComponent(new PositionComponent(MathUtils.random((float)800.0f), MathUtils.random((float)800.0f)));
        enemy.addComponent(new AccelerationComponent(10.0f));
        enemy.addComponent(new MaxVelocityComponent(100.0f));
        enemy.addComponent(new TeamComponent(2));
        enemy.addComponent(new TamedComponent());
        enemy.addComponent(new AIComponent(1));
        enemy.addComponent(new DirectionComponent(4));
        enemy.addComponent(new SoundEffectComponent(0));
        enemy.addComponent(this.longNeckSprite.copy());
        return enemy;
    }

    public Entity SalamanderEntity() {
        Entity enemy = new Entity();
        enemy.addComponent(new DefenseAreaComponent(-50.0f, -50.0f, 50.0f, 50.0f));
        enemy.addComponent(new AttackAreaComponent(0.0f, 0.0f, 0.0f, 0.0f));
        enemy.addComponent(new CurrentlyAttackingComponent(0.2f, false));
        enemy.addComponent(new HealthComponent(20));
        enemy.addComponent(new StrengthComponent(1));
        enemy.addComponent(new DefenseComponent(0));
        enemy.addComponent(new PositionComponent(MathUtils.random((float)800.0f), MathUtils.random((float)800.0f)));
        enemy.addComponent(new AccelerationComponent(10.0f));
        enemy.addComponent(new MaxVelocityComponent(100.0f));
        enemy.addComponent(new HealthRegenComponent(5, 3.5f));
        enemy.addComponent(new TeamComponent(2));
        enemy.addComponent(new TamedComponent());
        enemy.addComponent(new AIComponent(1));
        enemy.addComponent(this.salamanderSprite.copy());
        enemy.addComponent(new DirectionComponent(4));
        return enemy;
    }

    public Entity TriceritopsEntity() {
        Entity enemy = new Entity();
        enemy.addComponent(new DefenseAreaComponent(-50.0f, -50.0f, 50.0f, 50.0f));
        enemy.addComponent(new AttackAreaComponent(0.0f, 0.0f, 0.0f, 0.0f));
        enemy.addComponent(new CurrentlyAttackingComponent(0.5f, false));
        enemy.addComponent(new HealthComponent(20));
        enemy.addComponent(new StrengthComponent(3));
        enemy.addComponent(new DefenseComponent(1));
        enemy.addComponent(new PositionComponent(MathUtils.random((float)800.0f), MathUtils.random((float)800.0f)));
        enemy.addComponent(new AccelerationComponent(10.0f));
        enemy.addComponent(new MaxVelocityComponent(100.0f));
        enemy.addComponent(new TeamComponent(2));
        enemy.addComponent(new TamedComponent());
        enemy.addComponent(new AIComponent(1));
        enemy.addComponent(this.triceritopsSprite.copy());
        enemy.addComponent(new DirectionComponent(4));
        return enemy;
    }

    public SpriteComponent getPlayerSprite() {
        return this.playerSprite;
    }

    public void setPlayerSprite(SpriteComponent playerSprite) {
        this.playerSprite = playerSprite;
    }

    public SpriteComponent getLongNeckSprite() {
        return this.longNeckSprite;
    }

    public void setLongNeckSprite(SpriteComponent longNeckSprite) {
        this.longNeckSprite = longNeckSprite;
    }

    public SpriteComponent getSalamanderSprite() {
        return this.salamanderSprite;
    }

    public void setSalamanderSprite(SpriteComponent salamanderSprite) {
        this.salamanderSprite = salamanderSprite;
    }

    public SpriteComponent getTriceritopsSprite() {
        return this.triceritopsSprite;
    }

    public void setTriceritopsSprite(SpriteComponent triceritopsSprite) {
        this.triceritopsSprite = triceritopsSprite;
    }
}

