/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.AIComponent;
import com.adsittech.dinotamer.AttackAreaComponent;
import com.adsittech.dinotamer.AttackEntityComponent;
import com.adsittech.dinotamer.Component;
import com.adsittech.dinotamer.CurrentlyAttackingComponent;
import com.adsittech.dinotamer.DamageComponent;
import com.adsittech.dinotamer.DefenseAreaComponent;
import com.adsittech.dinotamer.DefenseComponent;
import com.adsittech.dinotamer.Entity;
import com.adsittech.dinotamer.HealthComponent;
import com.adsittech.dinotamer.HitTrackerComponent;
import com.adsittech.dinotamer.KeyDownInterceptComponent;
import com.adsittech.dinotamer.KilledComponent;
import com.adsittech.dinotamer.MoveToLocationComponent;
import com.adsittech.dinotamer.PositionComponent;
import com.adsittech.dinotamer.StrengthComponent;
import com.adsittech.dinotamer.TamedComponent;
import com.adsittech.dinotamer.TeamComponent;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.TimeUtils;
import java.util.ArrayList;

public class EntityController {
    private ArrayList<Entity> entities = new ArrayList();
    private ObjectMap<Integer, Entity> attackingEntities = new ObjectMap();
    private ObjectMap<Integer, Entity> entityIDs = new ObjectMap();
    private ObjectMap<Integer, ArrayList<Entity>> teamEntities = new ObjectMap();

    public void addEntity(Entity toAdd) {
        this.entities.add(toAdd);
        this.entityIDs.put((Object)toAdd.getId(), (Object)toAdd);
        this.addEntityToTeam(toAdd);
    }

    public void addEntityToTeam(Entity toAdd) {
        TeamComponent team = (TeamComponent)toAdd.getComponent("TeamComponent");
        if (team != null) {
            if (this.teamEntities.get((Object)team.getTeam()) == null) {
                this.teamEntities.put((Object)team.getTeam(), new ArrayList());
            }
            ((ArrayList)this.teamEntities.get((Object)team.getTeam())).add(toAdd);
        }
    }

    public void removeEntity(int position) {
        Entity toRemove = this.entities.get(position);
        this.entityIDs.remove((Object)toRemove.getId());
        this.removeEntityFromTeam(toRemove);
        this.entities.remove(position);
    }

    public void removeEntityFromTeam(Entity toRemove) {
        TeamComponent team = (TeamComponent)toRemove.getComponent("TeamComponent");
        if (team != null) {
            if (this.teamEntities.get((Object)team.getTeam()) != null) {
                ((ArrayList)this.teamEntities.get((Object)team.getTeam())).remove(toRemove);
            }
            team.setTeam(-1);
        }
    }

    public void removeEntity(Entity toRemove) {
        this.entityIDs.remove((Object)toRemove.getId());
        this.removeEntityFromTeam(toRemove);
        this.entities.remove(toRemove);
    }

    public void updateEntities() {
        this.updateEntities(0.0f);
    }

    public int updateEntities(float delta) {
        int toReturn = 0;
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (Entity entity : this.entities) {
            entity.updateComponents(delta);
            if (entity.getComponent("CurrentlyAttackingComponent") != null) {
                if (((CurrentlyAttackingComponent)entity.getComponent("CurrentlyAttackingComponent")).checkAttacking()) {
                    if (!this.attackingEntities.containsKey((Object)entity.getId())) {
                        this.attackingEntities.put((Object)entity.getId(), (Object)entity);
                    }
                } else {
                    this.attackingEntities.remove((Object)entity.getId());
                }
            }
            this.calculateAIUpdates(entity, delta);
            AttackEntityComponent attackEntity = (AttackEntityComponent)entity.getComponent("AttackEntityComponent");
            if (attackEntity != null) {
                this.moveToAndAttackEntity(entity, (Entity)this.entityIDs.get((Object)attackEntity.getAttackEntity()));
            }
            for (Integer toCheck : this.attackingEntities.keys()) {
                this.checkAttackingEntity((Entity)this.attackingEntities.get((Object)toCheck), entity);
            }
            TeamComponent team = (TeamComponent)entity.getComponent("TeamComponent");
            KilledComponent killed = (KilledComponent)entity.getComponent("KilledComponent");
            if (killed == null || !killed.getKilled()) continue;
            TamedComponent tamed = (TamedComponent)entity.getComponent("TamedComponent");
            if (tamed != null && !tamed.getTamed()) {
                tamed.setTamed(true);
                HealthComponent health = (HealthComponent)entity.getComponent("HealthComponent");
                this.removeEntityFromTeam(entity);
                if (team == null) {
                    team = new TeamComponent(1);
                    entity.addComponent(team);
                }
                entity.removeComponent("HealthRegenComponent");
                HitTrackerComponent hitTracker = (HitTrackerComponent)entity.getComponent("HitTrackerComponent");
                Entity lastHittingEntity = null;
                if (hitTracker != null) {
                    lastHittingEntity = (Entity)this.entityIDs.get((Object)hitTracker.getLastHittingEntityID());
                }
                if (lastHittingEntity != null) {
                    TeamComponent tamerTeam = (TeamComponent)lastHittingEntity.getComponent("TeamComponent");
                    team.setTeam(tamerTeam.getTeam());
                }
                this.addEntityToTeam(entity);
                health.setHealth(health.getTotalHealth() / 2);
                entity.removeComponent("KilledComponent");
                ++toReturn;
                continue;
            }
            toRemove.add(entity);
        }
        for (Entity entity : toRemove) {
            this.removeEntity(entity);
        }
        return toReturn;
    }

    public void calculateAIUpdates(Entity entity, float delta) {
        AIComponent ai = (AIComponent)entity.getComponent("AIComponent");
        if (ai != null) {
            ai.updateTimeSinceLastDecision(delta);
            if (ai.getAI() == 1) {
                this.rudimentaryAIControllerUpdate(entity, ai);
            }
        }
    }

    public void moveToAndAttackEntity(Entity attacker, Entity defender) {
        if (attacker != null && defender != null) {
            DefenseAreaComponent defenseArea = (DefenseAreaComponent)defender.getComponent("DefenseAreaComponent");
            PositionComponent defenderPosition = (PositionComponent)defender.getComponent("PositionComponent");
            AttackAreaComponent attackArea = (AttackAreaComponent)attacker.getComponent("AttackAreaComponent");
            PositionComponent attackerPosition = (PositionComponent)attacker.getComponent("PositionComponent");
            TeamComponent attackerTeam = (TeamComponent)attacker.getComponent("TeamComponent");
            TeamComponent defenderTeam = (TeamComponent)defender.getComponent("TeamComponent");
            boolean sameTeam = true;
            if (attackerTeam == null || defenderTeam == null || attackerTeam.getTeam() != defenderTeam.getTeam()) {
                sameTeam = false;
            }
            if (sameTeam) {
                attacker.removeComponent("AttackEntityComponent");
            } else if (attackArea != null && defenseArea != null && defenderPosition != null && attackerPosition != null) {
                Rectangle actualDefenseRectangle;
                Rectangle actualAttackRectangle = EntityController.getActualAttackAreaRectangle(attacker);
                if (actualAttackRectangle.overlaps(actualDefenseRectangle = EntityController.getActualDefenseAreaRectangle(defender))) {
                    CurrentlyAttackingComponent attacking = (CurrentlyAttackingComponent)attacker.getComponent("CurrentlyAttackingComponent");
                    if (attacking != null) {
                        attacking.startAttack();
                    }
                } else {
                    attacker.addComponent(new MoveToLocationComponent(defenderPosition.getPosition().x - attackArea.getAttackArea().x + attackArea.getAttackArea().width / 2.0f, defenderPosition.getPosition().y - attackArea.getAttackArea().y + attackArea.getAttackArea().height / 2.0f));
                }
            }
        }
    }

    public void rudimentaryAIControllerUpdate(Entity entity, AIComponent ai) {
        if (ai.getTimeSinceLastDecision() >= 3.5f) {
            AttackEntityComponent attackEntity = (AttackEntityComponent)entity.getComponent("AttackEntityComponent");
            MoveToLocationComponent moveTo = (MoveToLocationComponent)entity.getComponent("MoveToLocationComponent");
            PositionComponent currentPosition = (PositionComponent)entity.getComponent("PositionComponent");
            if (currentPosition != null) {
                int randomNumber;
                int changeActivityChance = 10;
                if (attackEntity == null && (moveTo == null || Math.abs(moveTo.getMoveToLocation().x - currentPosition.getPosition().x + Math.abs(moveTo.getMoveToLocation().y - currentPosition.getPosition().y)) < 5.0f)) {
                    changeActivityChance = 100;
                }
                if (changeActivityChance >= (randomNumber = MathUtils.random((int)100))) {
                    entity.removeComponent("AttackEntityComponent");
                    entity.removeComponent("MoveToLocationComponent");
                    entity.removeComponent("VelocityComponent");
                    randomNumber = MathUtils.random((int)100);
                    boolean handled = false;
                    if (randomNumber <= 50 && this.entities.size() > 1) {
                        TeamComponent team = (TeamComponent)entity.getComponent("TeamComponent");
                        int i = 0;
                        while (i < 10) {
                            Entity toAttack = this.entities.get(MathUtils.random((int)(this.entities.size() - 1)));
                            TeamComponent toAttackTeam = (TeamComponent)toAttack.getComponent("TeamComponent");
                            if (toAttack.getId() != entity.getId() && (team == null || toAttackTeam == null || team.getTeam() != toAttackTeam.getTeam())) {
                                handled = true;
                                i = 20;
                                entity.addComponent(new AttackEntityComponent(toAttack.getId()));
                            }
                            ++i;
                        }
                    }
                    if (!handled && randomNumber <= 80) {
                        entity.addComponent(new MoveToLocationComponent(MathUtils.random((float)800.0f), MathUtils.random((float)800.0f)));
                        handled = true;
                    }
                    ai.resetDecisionTime();
                }
            }
        }
    }

    public static Rectangle getActualDefenseAreaRectangle(Entity defender) {
        DefenseAreaComponent defenseArea = (DefenseAreaComponent)defender.getComponent("DefenseAreaComponent");
        PositionComponent defenderPosition = (PositionComponent)defender.getComponent("PositionComponent");
        if (defenseArea != null && defenderPosition != null) {
            Rectangle actualDefenseArea = new Rectangle(defenseArea.getDefenseArea());
            actualDefenseArea.x += defenderPosition.getPosition().x;
            actualDefenseArea.y += defenderPosition.getPosition().y;
            return actualDefenseArea;
        }
        return null;
    }

    public static Rectangle getActualAttackAreaRectangle(Entity attacker) {
        AttackAreaComponent attackArea = (AttackAreaComponent)attacker.getComponent("AttackAreaComponent");
        PositionComponent attackerPosition = (PositionComponent)attacker.getComponent("PositionComponent");
        if (attackArea != null && attackerPosition != null) {
            Rectangle actualAttackArea = new Rectangle(attackArea.getAttackArea());
            actualAttackArea.x += attackerPosition.getPosition().x;
            actualAttackArea.y += attackerPosition.getPosition().y;
            return actualAttackArea;
        }
        return null;
    }

    public void checkAttackingEntity(Entity attacker, Entity defender) {
        if (attacker.getId() != defender.getId()) {
            CurrentlyAttackingComponent currentlyAttacking = (CurrentlyAttackingComponent)attacker.getComponent("CurrentlyAttackingComponent");
            if (currentlyAttacking != null && currentlyAttacking.checkAttacking()) {
                TeamComponent attackerTeam = (TeamComponent)attacker.getComponent("TeamComponent");
                TeamComponent defenderTeam = (TeamComponent)defender.getComponent("TeamComponent");
                boolean sameTeam = true;
                if (attackerTeam == null || defenderTeam == null || attackerTeam.getTeam() != defenderTeam.getTeam()) {
                    sameTeam = false;
                }
                Rectangle actualAttackArea = EntityController.getActualAttackAreaRectangle(attacker);
                Rectangle actualDefenseArea = EntityController.getActualDefenseAreaRectangle(defender);
                if (!sameTeam && actualAttackArea != null && actualDefenseArea != null) {
                    HitTrackerComponent hitTracker = (HitTrackerComponent)defender.getComponent("HitTrackerComponent");
                    if (hitTracker == null) {
                        hitTracker = new HitTrackerComponent();
                        defender.addComponent(hitTracker);
                    }
                    long lastHitTime = hitTracker.getLastHitTime(attacker.getId());
                    if (actualAttackArea.overlaps(actualDefenseArea) && (float)(TimeUtils.millis() - lastHitTime) > currentlyAttacking.getTotalAttackDuration() * 1000.0f) {
                        StrengthComponent strength = (StrengthComponent)attacker.getComponent("StrengthComponent");
                        DefenseComponent defense = (DefenseComponent)defender.getComponent("DefenseComponent");
                        hitTracker.recordHit(attacker.getId());
                        if (strength != null && defense != null) {
                            int damage = strength.getStrength() - defense.getDefense();
                            if (damage <= 0) {
                                damage = 0;
                                if (MathUtils.random((int)1) == 1) {
                                    damage = 1;
                                }
                            }
                            defender.addComponent(new DamageComponent(damage));
                        }
                    }
                }
            } else {
                this.attackingEntities.remove((Object)attacker.getId());
            }
        }
    }

    public void updateKeyDown(int keycode) {
        for (Entity entity : this.entities) {
            KeyDownInterceptComponent intercept = (KeyDownInterceptComponent)entity.getComponent("KeyDownInterceptComponent");
            if (intercept == null) continue;
            for (Component component : (ArrayList)intercept.getKeyCodesToComponents().get((Object)keycode, new ArrayList())) {
                entity.addComponent(component.copy());
            }
        }
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public ObjectMap<Integer, ArrayList<Entity>> getTeamEntities() {
        return this.teamEntities;
    }

    public ObjectMap<Integer, Entity> getAttackingEntities() {
        return this.attackingEntities;
    }
}

