/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.AccelerationComponent;
import com.adsittech.dinotamer.AttackAreaComponent;
import com.adsittech.dinotamer.Component;
import com.adsittech.dinotamer.CurrentlyAttackingComponent;
import com.adsittech.dinotamer.DamageComponent;
import com.adsittech.dinotamer.DefenseAreaComponent;
import com.adsittech.dinotamer.DirectionComponent;
import com.adsittech.dinotamer.HealthComponent;
import com.adsittech.dinotamer.HealthRegenComponent;
import com.adsittech.dinotamer.KilledComponent;
import com.adsittech.dinotamer.MaxVelocityComponent;
import com.adsittech.dinotamer.MoveToLocationComponent;
import com.adsittech.dinotamer.PositionComponent;
import com.adsittech.dinotamer.SpriteComponent;
import com.adsittech.dinotamer.VelocityComponent;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ObjectMap;

public class Entity {
    private ObjectMap<String, Component> components;
    private int id = numSoFar++;
    private static int numSoFar = 0;

    public Entity() {
        this.components = new ObjectMap();
    }

    public void addComponent(Component component) {
        if (!this.components.containsKey((Object)component.getComponentName())) {
            this.components.put((Object)component.getComponentName(), (Object)component);
        } else {
            ((Component)this.components.get((Object)component.getComponentName())).add(component);
        }
    }

    public void removeComponent(String componentName) {
        this.components.remove((Object)componentName);
    }

    public void updateComponents() {
        this.updateComponents(0.0f);
    }

    public void updateComponents(float delta) {
        this.updateHealth((HealthComponent)this.components.get((Object)"HealthComponent"), (DamageComponent)this.components.get((Object)"DamageComponent"), (HealthRegenComponent)this.components.get((Object)"HealthRegenComponent"), delta);
        this.removeComponent("DamageComponent");
        this.updateVelocity((AccelerationComponent)this.components.get((Object)"AccelerationComponent"), (MaxVelocityComponent)this.components.get((Object)"MaxVelocityComponent"), (MoveToLocationComponent)this.components.get((Object)"MoveToLocationComponent"), (PositionComponent)this.components.get((Object)"PositionComponent"), (VelocityComponent)this.components.get((Object)"VelocityComponent"));
        this.updatePosition((PositionComponent)this.components.get((Object)"PositionComponent"), (VelocityComponent)this.components.get((Object)"VelocityComponent"), delta);
        this.updateCurrentlyAttacking((CurrentlyAttackingComponent)this.components.get((Object)"CurrentlyAttackingComponent"), delta);
        this.updateDirection((DirectionComponent)this.components.get((Object)"DirectionComponent"), (VelocityComponent)this.components.get((Object)"VelocityComponent"));
        this.updateSpriteInformation((SpriteComponent)this.components.get((Object)"SpriteComponent"), (DirectionComponent)this.components.get((Object)"DirectionComponent"), (CurrentlyAttackingComponent)this.components.get((Object)"CurrentlyAttackingComponent"), (DefenseAreaComponent)this.components.get((Object)"DefenseAreaComponent"), (AttackAreaComponent)this.components.get((Object)"AttackAreaComponent"), delta);
    }

    private void updateSpriteInformation(SpriteComponent sprite, DirectionComponent directionComponent, CurrentlyAttackingComponent currentlyAttacking, DefenseAreaComponent defenseArea, AttackAreaComponent attackArea, float delta) {
        if (sprite != null) {
            Rectangle newDefense;
            sprite.updateTime(delta);
            if (directionComponent != null) {
                int direction = directionComponent.getDirection();
                if (currentlyAttacking != null && currentlyAttacking.checkAttacking()) {
                    Rectangle newAttack;
                    if (direction == 1) {
                        sprite.setCurrentState(8);
                    } else if (direction == 7) {
                        sprite.setCurrentState(12);
                    } else if (direction == 5) {
                        sprite.setCurrentState(14);
                        if (sprite.isFlipForEastWest()) {
                            sprite.setFlipEastWestNow(true);
                        }
                    } else if (direction == 4) {
                        sprite.setCurrentState(9);
                    } else if (direction == 3) {
                        sprite.setCurrentState(11);
                        if (sprite.isFlipForEastWest()) {
                            sprite.setFlipEastWestNow(true);
                        }
                    } else if (direction == 2) {
                        sprite.setCurrentState(10);
                    } else if (direction == 8) {
                        sprite.setCurrentState(13);
                    } else if (direction == 6) {
                        if (sprite.isFlipForEastWest()) {
                            sprite.setFlipEastWestNow(true);
                        }
                        sprite.setCurrentState(15);
                    }
                    if (attackArea != null && (newAttack = sprite.getAttackRectangle(sprite.retrieveCurrentTexture())) != null) {
                        attackArea.setAttackArea(newAttack);
                    }
                } else if (direction == 1) {
                    sprite.setCurrentState(0);
                } else if (direction == 7) {
                    sprite.setCurrentState(4);
                } else if (direction == 5) {
                    if (sprite.isFlipForEastWest()) {
                        sprite.setFlipEastWestNow(true);
                    }
                    sprite.setCurrentState(6);
                } else if (direction == 4) {
                    sprite.setCurrentState(1);
                } else if (direction == 3) {
                    sprite.setCurrentState(3);
                    if (sprite.isFlipForEastWest()) {
                        sprite.setFlipEastWestNow(true);
                    }
                } else if (direction == 2) {
                    sprite.setCurrentState(2);
                } else if (direction == 8) {
                    sprite.setCurrentState(5);
                } else if (direction == 6) {
                    sprite.setCurrentState(7);
                    if (sprite.isFlipForEastWest()) {
                        sprite.setFlipEastWestNow(true);
                    }
                }
            }
            if (defenseArea != null && (newDefense = sprite.getDefenseRectangle(sprite.retrieveCurrentTexture())) != null) {
                defenseArea.setDefenseArea(newDefense);
            }
        }
    }

    private void updateCurrentlyAttacking(CurrentlyAttackingComponent currentlyAttackingComponent, float delta) {
        if (currentlyAttackingComponent != null && currentlyAttackingComponent.checkAttacking()) {
            currentlyAttackingComponent.setCurrentAttackDuration(currentlyAttackingComponent.getCurrentAttackDuration() + delta);
        }
    }

    private void updateVelocity(AccelerationComponent acceleration, MaxVelocityComponent maxVelocity, MoveToLocationComponent moveTo, PositionComponent position, VelocityComponent currentVelocity) {
        if (acceleration != null && maxVelocity != null && moveTo != null && position != null) {
            float yDistance;
            float xDistance;
            float totalDistanceLeft;
            if (currentVelocity == null) {
                currentVelocity = new VelocityComponent(0.0f, 0.0f);
                this.addComponent(currentVelocity);
            }
            float currentTotalVelocity = (float)Math.sqrt(currentVelocity.getVelocity().x * currentVelocity.getVelocity().x + currentVelocity.getVelocity().y * currentVelocity.getVelocity().y);
            if ((currentTotalVelocity += acceleration.getAcceleration()) > maxVelocity.getMaxVelocity()) {
                currentTotalVelocity = maxVelocity.getMaxVelocity();
            }
            if ((totalDistanceLeft = (float)Math.sqrt((xDistance = position.getPosition().x - moveTo.getMoveToLocation().x) * xDistance + (yDistance = position.getPosition().y - moveTo.getMoveToLocation().y) * yDistance)) < currentTotalVelocity) {
                currentTotalVelocity = totalDistanceLeft;
            }
            float lineA = Math.abs(yDistance);
            float lineC = Math.abs(xDistance);
            float lineB = totalDistanceLeft;
            float angleA = 57.295776f * MathUtils.atan2((float)Math.abs(yDistance), (float)Math.abs(xDistance));
            float angleB = 90.0f;
            float angleC = 180.0f - (angleA + angleB);
            lineB = currentTotalVelocity;
            lineC = lineB / MathUtils.sinDeg((float)angleB) * MathUtils.sinDeg((float)angleC);
            if (xDistance > 0.0f) {
                lineC *= -1.0f;
            }
            lineA = lineB / MathUtils.sinDeg((float)angleB) * MathUtils.sinDeg((float)angleA);
            if (yDistance > 0.0f) {
                lineA *= -1.0f;
            }
            currentVelocity.getVelocity().x = lineC;
            currentVelocity.getVelocity().y = lineA;
        }
    }

    private void updateDirection(DirectionComponent direction, VelocityComponent velocity) {
        if (direction != null && velocity != null) {
            Vector2 v = velocity.getVelocity();
            if (v.x > 0.0f) {
                if (v.y > 0.0f) {
                    direction.setDirection(7);
                } else if (v.y < 0.0f) {
                    direction.setDirection(8);
                } else {
                    direction.setDirection(4);
                }
            } else if (v.x < 0.0f) {
                if (v.y > 0.0f) {
                    direction.setDirection(5);
                } else if (v.y < 0.0f) {
                    direction.setDirection(6);
                } else {
                    direction.setDirection(3);
                }
            } else if (v.y > 0.0f) {
                direction.setDirection(1);
            } else if (v.y < 0.0f) {
                direction.setDirection(2);
            }
        }
    }

    private void updateHealth(HealthComponent health, DamageComponent damage, HealthRegenComponent healthRegen, float delta) {
        if (health != null) {
            if (healthRegen != null) {
                healthRegen.updateTimer(delta);
                if (healthRegen.checkGenerateHealth()) {
                    health.setHealth(health.getHealth() + healthRegen.getHealthRegenAmount());
                    healthRegen.resetTime();
                }
            }
            if (damage != null) {
                health.setHealth(health.getHealth() - damage.getDamage());
                if (health.getHealth() <= 0) {
                    this.addComponent(new KilledComponent(true));
                }
            }
        }
    }

    private void updatePosition(PositionComponent position, VelocityComponent velocity, float delta) {
        if (position != null && velocity != null) {
            position.getPosition().add(new Vector2(velocity.getVelocity().x, velocity.getVelocity().y).scl(delta));
        }
    }

    public String toString() {
        String toReturn = "Entity ID:" + this.getId();
        for (String key : this.components.keys()) {
            toReturn = String.valueOf(toReturn) + "\n--" + this.components.get((Object)key);
        }
        return toReturn;
    }

    public Component getComponent(String key) {
        return (Component)this.components.get((Object)key);
    }

    public int getId() {
        return this.id;
    }
}

