/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Component;

public class AIComponent
extends Component {
    private int ai;
    private float timeSinceLastDecision;
    public static final int RUDIMENTARY = 1;
    public static final float TIME_RUDIMENTARY = 3.5f;

    public AIComponent(int ai) {
        this.setAI(ai);
        if (ai == 1) {
            this.setTimeSinceLastDecision(3.5f);
        } else {
            this.setTimeSinceLastDecision(100.0f);
        }
    }

    public void updateTimeSinceLastDecision(float delta) {
        this.timeSinceLastDecision += delta;
    }

    public void resetDecisionTime() {
        this.timeSinceLastDecision = 0.0f;
    }

    @Override
    public String getComponentName() {
        return "AIComponent";
    }

    @Override
    public void add(Component toAdd) {
        if (this.sameType(toAdd)) {
            this.ai += ((AIComponent)toAdd).getAI();
        }
    }

    public int getAI() {
        return this.ai;
    }

    public void setAI(int ai) {
        this.ai = ai;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "-[" + this.ai + ", " + this.timeSinceLastDecision + "]";
    }

    @Override
    public Component copy() {
        return new AIComponent(this.ai);
    }

    public float getTimeSinceLastDecision() {
        return this.timeSinceLastDecision;
    }

    public void setTimeSinceLastDecision(float timeSinceLastDecision) {
        this.timeSinceLastDecision = timeSinceLastDecision;
    }
}

